<?php
// CDN　dnsプリヘッチを停止する
function remove_dns_prefetch( $hints, $relation_type ) {
    if ( 'dns-prefetch' === $relation_type ) {
        return array_diff( wp_dependencies_unique_hosts(), $hints );
    }
    return $hints;
}
add_filter( 'wp_resource_hints', 'remove_dns_prefetch', 10, 2 );
// titleタグをhead内に生成する
//add_theme_support( 'title-tag' );
	
// HTML5でマークアップさせる
//add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list', 'gallery', 'caption' ) );
	
// Feedのリンクを自動で生成する
//add_theme_support( 'automatic-feed-links' );
	
//外観項目にメニュー項目を追加する
//register_nav_menu('mainmenu', 'メインメニュー'); 

//アイキャッチ画像表示
add_theme_support( 'post-thumbnails' );

// カスタムヘッダー機能を有効化
add_theme_support( 'custom-header' ); 

// ウィジェット内ショートコードを有効化
add_filter('widget_text', 'do_shortcode' );

register_sidebar(array (
'name' => 'サイドバーウェジェット',
'id' => 'sid-bar',
'description' => '',
'before_widget' => '<div  id="%1$s" class="%2$s nav-blo">',
'after_widget' => '</div>',
'before_title' => '<h2 class="nav-tit">',
'after_title' => '</h2><hr>',
 ));


//WordPress自動挿Pタグを無効化
    add_filter('the_content', 'wpautop_filter', 9);
    function wpautop_filter($content) {
        global $post;
        $remove_filter = false;
        $arr_types = array('page'); //自動整形を無効にする投稿タイプを記述
        $post_type = get_post_type( $post->ID );
        if (in_array($post_type, $arr_types)) $remove_filter = true;
        if ( $remove_filter ) {
            remove_filter('the_content', 'wpautop');
            remove_filter('the_excerpt', 'wpautop');
        }
        return $content;
    }

//WordPress自動挿各種タグを無効化
remove_action('wp_head', 'print_emoji_detection_script', 7);
remove_action('admin_print_scripts', 'print_emoji_detection_script');
remove_action('wp_print_styles', 'print_emoji_styles' );
remove_action('admin_print_styles', 'print_emoji_styles');
remove_action('wp_head','rest_output_link_wp_head');
remove_action('wp_head','wp_oembed_add_discovery_links');
remove_action('wp_head','wp_oembed_add_host_js');
remove_action('wp_head', 'rsd_link');
remove_action( 'wp_head', 'wlwmanifest_link' );

//外観にメニュー機能を有効化
add_theme_support('menus');

function lab_setup() {
	register_nav_menus( array(
		'global' => 'グローバルナビ',
		'header' => 'ヘッダーナビ',
		'footer' => 'フッターナビ',
	) );
	
}
add_action( 'after_setup_theme', 'lab_setup' );

//  メニュータグからクラスを削除して、表示中メニューに 'current' クラスを付与する
add_filter( 'nav_menu_css_class', 'my_custom_nav', 10, 2 );
function my_custom_nav( $classes, $item ) {
    //     $classes を空にする前にカスタムクラスを変数へ入れておく        
    if( !empty( $classes[0] ) ){
        $custom_class = esc_attr( $classes[0] );
	}
	$classes = array();
    if( $item -> current == true ) {
        $classes[] = 'current';
	}
    $custom_class = 'men-lis';//liに入れるクラス名
    // 先に変数に入れておいたカスタムクラス名を配列へ入れる
    if( !empty( $custom_class ) ){
        $classes[] = $custom_class;
	}
    return $classes;
}
// メニュータグからID を削除する 
add_filter('nav_menu_item_id', 'removeId', 10);
function removeId( $id ){ 
    return $id = array(); 
}

//ページネーション
function get_responsive_pagination($_pagination_range_pc,$_pagination_range_sp){
    global $wp_query;
    $total_posts_num = $wp_query->found_posts;
    //記事数が0の場合終了
    if ($total_posts_num == 0) return;
    //1ページに表示する範囲
    $page_range = get_query_var('posts_per_page');
    //合計ページ数
    $total_page_num = ceil($total_posts_num/$page_range);
    //現在のページを取得
    $index_page_num = get_query_var('paged') ? get_query_var('paged') :1 ;
    //開始件数を取得
    $from = $page_range * ($index_page_num - 1 ) + 1;
    //終了件数を取得
    $to = $page_range * $index_page_num;
    //開始件数から終了件数
    $from_to = '';
    //合計該当記事数が終了件数より小さい場合、終了件数に設定
    if($total_posts_num <= $to)$to = $total_posts_num;
    if($total_posts_num == 1 ){
        $from_to = $from;
    }else{
        $from_to = $from.'〜'.$to;
    }
    if($from == $to)$from_to = $from;
    /* PC */
    $pagination_range = $_pagination_range_pc;
    //ページャー範囲が合計ページ数より多い場合
    if ($pagination_range >= $total_page_num) $pagination_range = $total_page_num;
    $pagination_offset = floor($pagination_range / 2);
    $pagination_from_limit = $total_page_num - $pagination_range + 1;
    $offset_from = $index_page_num - $pagination_offset;
    if ($offset_from <= 1) $offset_from = 1;
    if ($offset_from >= $pagination_from_limit) $offset_from = $pagination_from_limit;
    $offset_to = $offset_from + $pagination_range;

    /* SP */
    $pagination_range_sp = $_pagination_range_sp;
    //ページャー範囲が合計ページ数より多い場合
    if ($pagination_range_sp >= $total_page_num) $pagination_range_sp = $total_page_num;
    $pagination_offset_sp = floor($pagination_range_sp / 2);
    $pagination_from_limit_sp = $total_page_num - $pagination_range_sp + 1;
    $offset_from_sp = $index_page_num - $pagination_offset_sp;
    if ($offset_from_sp <= 1) $offset_from_sp = 1;
    if ($offset_from_sp >= $pagination_from_limit_sp) $offset_from_sp = $pagination_from_limit_sp;
    $offset_to_sp = $offset_from_sp + $pagination_range_sp;

    $add_class = '';
    $source = '';
    if($total_page_num > $_pagination_range_sp + 2 ) $add_class .= ' pagination-range-over-sp';
    if($total_page_num > $_pagination_range_pc + 2 ) $add_class .= ' pagination-range-over-pc';
    $source .= '<nav class="pag-nav'.$add_class.'">'."\n";
    $source .= '<ul class="clearfix">'."\n";

    //prev first
    if($index_page_num != 1 ) {
        $source .= '<li class="pagination-no-num first"><a href="'.get_pagenum_link(1).'"><i class="fas fa-angle-double-left"></i></a></li>'."\n";
        $source .= '<li class="pagination-no-num prev"><a href="'.get_pagenum_link($index_page_num - 1).'"><i class="fas fa-angle-left"></i></span></a></li>'."\n";
    }else{
        $source .= '<li class="pagination-no-num first"><span><i class="fas fa-angle-left"></i></span></li>'."\n";
        $source .= '<li class="pagination-no-num prev"><span><i class="fas fa-angle-double-left"></i></span></li>'."\n";
    }

    for ($i=$offset_from; $i < $offset_to; $i++){
        if($index_page_num == $i){
            if($i>=$offset_from_sp && $i<$offset_to_sp){
                $source .= '<li class="pagination-index pagination-sp"><span>'.$i.'</span></li>'."\n";
            }else{
                $source .= '<li class="pagination-index"><span>'.$i.'</span></li>'."\n";
            }
        }else{
            if($i>=$offset_from_sp && $i<$offset_to_sp){
                $source .= '<li class="pagination-sp"><a href="'.get_pagenum_link($i).'">'.$i.'</a></li>'."\n";
            }else{
                $source .= '<li><a href="'.get_pagenum_link($i).'">'.$i.'</a></li>'."\n";
            }
        }
    }

    //next last
    if($index_page_num != $total_page_num) {
        $source .= '<li class="pagination-no-num next"><a href="'.get_pagenum_link($index_page_num + 1).'"><i class="fas fa-angle-right"></i></a></li>'."\n";
        $source .= '<li class="pagination-no-num last"><a href="'.get_pagenum_link($total_page_num).'"><i class="fas fa-angle-double-right"></i></a></li>'."\n";
    }else{
        $source .= '<li class="pagination-no-num next"><span><i class="fas fa-angle-right"></i></span></li>'."\n";
        $source .= '<li class="pagination-no-num last"><span><i class="fas fa-angle-double-right"></i></span></li>'."\n";
    }

    $source .= '</ul>'."\n";
    $source .= '</nav>'."\n";
    $source .= '<div class="pagination-txt">'.$from_to.'<span> / '.$total_posts_num.'件</div>'."\n";

    echo $source;

}

//よく見られる記事一覧
function getPostViews($postID){
	$count_key = 'post_views_count';
	$count = get_post_meta($postID, $count_key, true);
	if($count==''){
			delete_post_meta($postID, $count_key);
			add_post_meta($postID, $count_key, '0');
			return "0 View";
	}
	return $count.' Views';
}
function setPostViews($postID) {
	$count_key = 'post_views_count';
	$count = get_post_meta($postID, $count_key, true);
	if($count==''){
			$count = 0;
			delete_post_meta($postID, $count_key);
			add_post_meta($postID, $count_key, '0');
	}else{
			$count++;
			update_post_meta($postID, $count_key, $count);
	}
}
remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0);

// ログインしないとサイトを見れない
function my_require_login() {
  global $pagenow;
  if ( ! is_user_logged_in() &&
       $pagenow !== 'wp-login.php' &&
       ! ( defined( 'DOING_AJAX' ) && DOING_AJAX ) &&
       ! ( defined( 'DOING_CRON' ) && DOING_CRON ) ) {
      auth_redirect();
  }
}
//add_action( 'init', 'my_require_login' ); //無効

//　ログイン画面 ロゴカスタマイズ
function custom_login_logo() { ?>
  <style>
    .login #login h1 a{
      width: 100%;
      height:140px;
      background:url(<?php echo get_stylesheet_directory_uri(); ?>/images/but_log01.png) no-repeat center;
	background-size: 50% auto;
    }
  </style>
<?php }
add_action( 'login_enqueue_scripts', 'custom_login_logo' );
function custom_login_logo_url() {
  return get_bloginfo( 'url' );
}
add_filter( 'login_headerurl', 'custom_login_logo_url' );

//Gutenberg用CSS読み込み削除
//theme.min.css削除はwp_dequeue_style( 'wp-block-library-theme' );を追記
add_action( 'wp_enqueue_scripts', 'remove_block_library_style' );
function remove_block_library_style() {
  wp_dequeue_style( 'wp-block-library' );
}